// Sistema de Tabs para Facultad de Educacion y Humanidades
document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');

            // Remover clase active de todos los botones y contenidos
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));

            // Agregar clase active al boton clickeado y su contenido correspondiente
            this.classList.add('active');
            document.getElementById(targetTab).classList.add('active');
        });
    });

    // Smooth scroll para las tarjetas de carreras
    const carreraBtns = document.querySelectorAll('.carrera-btn');
    carreraBtns.forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            // Aqui se puede agregar logica para mostrar mas informacion
            console.log('Ver mas informacion de la carrera');
        });
    });
});
